IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_REL_FLUXO_ANALIT]') AND type IN ( N'FN', N'IF', N'TF', N'FS', N'FT' ))
BEGIN
	DROP FUNCTION [dbo].[UFD_REL_FLUXO_ANALIT]
END
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20240319
'Job.................:  
'Nome................: [UFD_REL_FLUXO_ANALIT]
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 19/03/2024
'Dt Ult Alteraco....: --
'Criado por..........: Juan Andres Fernandez Mello
'Versionado por......: Marcos Barros
'=======================================================================================
*/
CREATE FUNCTION [dbo].[UFD_REL_FLUXO_ANALIT]   (@CD_EMP       INT,
												@NR_CNT       VARCHAR(250),
												@DT_INI       DATETIME,
												@DT_FIM       DATETIME,
												@TP           INT,
												@TP_DT        INT,
												@TP_RAT_CUSTO INT,
												@TP_REL       INT)
RETURNS @RETORNO_FLUXO TABLE(
	CD_DESP_REC        INT,
	CD_CHAVE           VARCHAR(250),
	CD_CENTRO_CTB_REDU INT,
	NR_DP              INT,
	PARC               INT,
	DT_EMI             DATETIME,
	DT_SEL_REL         DATETIME,
	DT_PGTO            DATETIME,
	CD_EMP             INT,
	CD_FILIAL          INT,
	CD_FORN            INT,
	CD_TP_FORN         INT,
	FORN               VARCHAR(500),
	DOC                VARCHAR(250),
	HIST               VARCHAR(500),
	VLR_DP             MONEY,
	VLR_SLD            MONEY,
	VLR_DESP           MONEY,
	VLR_DESP_BRUTA     MONEY,
	VLR_IMP_DEB			MONEY,
	DESC_DEV			MONEY,
	TAXA_JUROS			MONEY,
	VLR_LIQ				MONEY,	
	DS_TP              VARCHAR(150),
	TRANSACAO          VARCHAR (60),
	DS_DESP_REC        VARCHAR(250),
	HIST_PG_CRED       VARCHAR(450),
	DS_CENTRO_CTB      VARCHAR(150),
	DT_VENCTO          DATETIME,
	NM_FORN			   VARCHAR(500),
	DUP_IMPOSTO        VARCHAR(50),
	CD_FILIAL_CRED          INT)
AS
	BEGIN
			DECLARE @RS_FLUXO TABLE
				(
					 CD_DESP_REC        INT,
					 CD_CHAVE           VARCHAR(250),
					 CD_CENTRO_CTB_REDU INT,
					 NR_DP              INT,
					 PARC               INT,
					 DT_EMI             DATETIME,
					 DT_SEL_REL         DATETIME,
					 DT_PGTO            DATETIME,
					 CD_EMP             INT,
					 CD_FILIAL          INT,
					 CD_FORN            INT,
					 CD_TP_FORN         INT,
					 FORN               VARCHAR(500),
					 DOC                VARCHAR(250),
					 HIST               VARCHAR(500),
					 VLR_DP             MONEY,
					 VLR_SLD            MONEY,
					 VLR_DESP           MONEY,
					 VLR_DESP_BRUTA     MONEY,
					 VLR_IMP_DEB		MONEY,
					 DESC_DEV			MONEY,
					 TAXA_JUROS			MONEY,
					 VLR_LIQ			MONEY,					 
					 DS_TP              VARCHAR(150),
					 TRANSACAO          VARCHAR (60),
					 DS_DESP_REC        VARCHAR(250),
					 HIST_PG_CRED       VARCHAR(450),
					 DS_CENTRO_CTB      VARCHAR(150),
					 DT_VENCTO          DATETIME,
					 NM_FORN			   VARCHAR(500),
					 DUP_IMPOSTO INT,
					 CD_FILIAL_CRED          INT)
			
			DECLARE @CALC_IMP TABLE	(CD_DESP_REC INT,NR_DP INT,VLR_IMP_DEB MONEY)
			BEGIN
				INSERT INTO @CALC_IMP
				SELECT 
						 T4.CD_DESP_REC
						,T1.NR_DP		
						,CASE T4.FLAG_RATEIO_IMPOSTO WHEN 1 THEN (T1.VLR_IMP_DEB / 100) * ((T3.VLR_DESP / SUM(T3.VLR_DESP)) * 100) ELSE 0 END AS VLR_IMP_DEB

				FROM	V_PG_CRED T1
						
						INNER JOIN PG_DESP_RAT_PG_CRED T2 ON
						T1.CD_EMP = T2.CD_EMP AND
						T1.CD_FILIAL = T2.CD_FILIAL AND
						T1.NR_DP = T2.NR_DP AND
						T1.ANO = T2.ANO

						INNER JOIN PG_DESP_RAT T3 ON
						T2.CD_EMP = T3.CD_EMP AND
						T2.CD_FILIAL = T3.CD_FILIAL AND
						T2.CD_RAT_DESP = T3.CD_RAT_DESP

						INNER JOIN GLB_DESP_REC T4 ON
						T3.CD_EMP = T4.CD_EMP AND
						T3.CD_DESP_REC = T4.CD_DESP_REC
						
				WHERE
						T1.CD_EMP = @CD_EMP AND
						(CASE WHEN @TP_DT = 0 THEN T1.DT_EMIS
						WHEN @TP_DT = 1 THEN T1.DT_CAD
						WHEN @TP_DT = 2 THEN T1.DT_VENCTO
						WHEN @TP_DT = 4 THEN T1.DT_PAG
						ELSE T3.MES_ANO_REF
						END ) BETWEEN @DT_INI AND @DT_FIM AND
						T1.STS_DP <> 3
						AND
						( CASE WHEN @TP = 0 THEN @NR_CNT
						ELSE T4.NR_CNT
						END )             = @NR_CNT AND
						( CASE WHEN @TP_RAT_CUSTO = 0 THEN 1
						ELSE T4.RATEIO_CENTRO_CUSTO
						END )             = 1		


				GROUP BY	T4.CD_DESP_REC
							,T3.VLR_DESP
							,T1.NR_DP
							,T4.FLAG_RATEIO_IMPOSTO
							,T1.VLR_IMP_DEB			
			
			END
			
			BEGIN
					--Duplicatas normais do contas a pagar
					INSERT INTO @RS_FLUXO
					SELECT
						GLB_DESP_REC.CD_DESP_REC
						,GLB_DESP_REC.NR_CNT
						,ISNULL(CTB_CENTRO_CUSTO.CD_CENTRO_CTB_REDU, 0) CD_CENTRO_CTB_REDU
						,V_PG_CRED.NR_DP
						,V_PG_CRED.PARC
						,V_PG_CRED.DT_EMIS
						,( CASE WHEN @TP_REL = 0 THEN NULL
							 ELSE ( CASE WHEN @TP_DT = 0 THEN V_PG_CRED.DT_EMIS
											WHEN @TP_DT = 1 THEN V_PG_CRED.DT_CAD
											WHEN @TP_DT = 2 THEN V_PG_CRED.DT_VENCTO
											WHEN @TP_DT = 4 THEN V_PG_CRED.DT_PAG
											ELSE PG_DESP_RAT.MES_ANO_REF
											END )
							 END )                                        AS DT_SEL_REL
						,MAX(DT_PAG)                                    DT_PGTO
						,V_PG_CRED.CD_EMP
						,ISNULL(CTB_CENTRO_CUSTO_PRC_FILIAL.CD_FILIAL,V_PG_CRED.CD_FILIAL) AS CD_FILIAL
						,V_PG_CRED.CD_FORN
						,PG_FORN.CD_TP_FORN
						,PG_FORN.NM_FANT
						,MIN(V_PG_CRED.NR_TIT) AS NR_TIT
						,CTB_HIST.DS_HIST

/*:::::::::::::::::::::::::: VLR_DP::::::::::::::::::::::::::::::::::::::::::::::*/
						,(	CASE WHEN SUM(VLR_DOC) > 0 THEN
								 CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
									SUM(DISTINCT ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_DP+V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB)) / (CASE WHEN VLR_DOC = 0 THEN 1 ELSE VLR_DOC END)), 
													PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_DP+V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB)) / (CASE WHEN VLR_DOC = 0 THEN 1 ELSE VLR_DOC END))))
								ELSE 
									SUM(DISTINCT ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * ( V_PG_CRED.VLR_DP / ( CASE WHEN VLR_DOC = 0 THEN  1 ELSE  VLR_DOC END)), 
													PG_DESP_RAT.VLR_DESP * ( V_PG_CRED.VLR_DP / ( CASE WHEN VLR_DOC = 0 THEN 1 ELSE VLR_DOC END ))))
								END
							ELSE 
								0
							END ) AS VLR_DP 

/*:::::::::::::::::::::::::: VLR_SLD::::::::::::::::::::::::::::::::::::::::::::::*/
						,( CASE WHEN SUM(VLR_DOC) > 0 THEN
								 CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
									SUM(DISTINCT ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * ( V_PG_CRED.VLR_SLD / ( CASE WHEN VLR_DOC = 0 THEN 1 ELSE VLR_DOC END)), 
														PG_DESP_RAT.VLR_DESP * ( V_PG_CRED.VLR_SLD / ( CASE WHEN VLR_DOC = 0 THEN 1 ELSE VLR_DOC END ) )))
								 ELSE 
									SUM(DISTINCT ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * ( V_PG_CRED.VLR_SLD / ( CASE WHEN VLR_DOC = 0 THEN 1 ELSE VLR_DOC END ) ), 
											PG_DESP_RAT.VLR_DESP * ( V_PG_CRED.VLR_SLD / ( CASE WHEN VLR_DOC = 0 THEN 1 ELSE VLR_DOC END ) ))) 
								 END
							 ELSE 0
							 END ) AS VLR_SLD

/*:::::::::::::::::::::::::: VLR_DESP::::::::::::::::::::::::::::::::::::::::::::::*/
						,( CASE WHEN SUM(VLR_DOC) > 0 THEN 
								( CASE WHEN @TP_DT IN ( 0, 1, 2, 3 ) THEN 
									CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA+V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB)) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
												1 
											ELSE 
												VLR_DOC
											END))))											
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA+V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB)) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
													1
												ELSE 
													VLR_DOC
												END )
											
											))))
									ELSE
										SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - 
										( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / (( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) ) ) * V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) 
										/ ( CASE WHEN VLR_DOC = 0 THEN 
												1
											ELSE 
												VLR_DOC
										END)), (PG_DESP_RAT.VLR_DESP - (V_PG_CRED.VLR_DESC_DEB - V_PG_CRED.VLR_DESP_OUTR + V_PG_CRED.VLR_IMP_DEB + V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) 
										/ ( CASE WHEN VLR_DOC = 0 THEN 
												1
											ELSE 
												VLR_DOC
											END))))
									END
									ELSE 
										CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA+V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB)) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
												1 
											ELSE 
												VLR_DOC
											END))))
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA +V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB))
											/ ( CASE WHEN VLR_DOC = 0 THEN 
													1
												ELSE 
													VLR_DOC
												END )
											
											))))
										 ELSE
											SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - ( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / ( CONVERT(NUMERIC(32, 8), ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS )) ) ) * 
											( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) ) * ( ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
												1 
											ELSE 
												VLR_DOC
											END ) ), (PG_DESP_RAT.VLR_DESP - ( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) * ( ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
													1
												ELSE 
													VLR_DOC
												END ) )))
										END
									END )
							 ELSE 
								0
							 END )                                    AS VLR_DESP

/*:::::::::::::::::::::::::: VLR_DESP_BRUTA ::::::::::::::::::::::::::::::::::::::::::::::*/
					    , ( CASE WHEN SUM(VLR_DOC) > 0 THEN 
								( CASE WHEN @TP_DT IN ( 0, 1, 2, 3 ) THEN 
									CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA ) ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
												1 
											ELSE 
												VLR_DOC
											END))))											
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA) ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
													1
												ELSE 
													VLR_DOC
												END )
											
											))))
									ELSE
										SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - 
										( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / (( V_PG_CRED.VLR_DP  ) ) ) * V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP  ) 
										/ ( CASE WHEN VLR_DOC = 0 THEN 
												1
											ELSE 
												VLR_DOC
										END)), (PG_DESP_RAT.VLR_DESP - (V_PG_CRED.VLR_DESC_DEB - V_PG_CRED.VLR_DESP_OUTR + V_PG_CRED.VLR_IMP_DEB + V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) 
										/ ( CASE WHEN VLR_DOC = 0 THEN 
												1
											ELSE 
												VLR_DOC
											END))))
									END
									ELSE 
										CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA) ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
												1 
											ELSE 
												VLR_DOC
											END))))
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA ) )
											/ ( CASE WHEN VLR_DOC = 0 THEN 
													1
												ELSE 
													VLR_DOC
												END )
											
											))))
										 ELSE
											SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - ( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / ( CONVERT(NUMERIC(32, 8), ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS )) ) ) * 
											( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) ) * ( ( V_PG_CRED.VLR_DP   ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
												1 
											ELSE 
												VLR_DOC
											END ) ), (PG_DESP_RAT.VLR_DESP - ( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) * ( ( V_PG_CRED.VLR_DP  ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
													1
												ELSE 
													VLR_DOC
												END ) )))
										END
									END )
							 ELSE 
								0		
						END )                                			AS VLR_DESP_BRUTA

						,ISNULL(T0.VLR_IMP_DEB,0) AS VLR_IMP_DEB
						,(V_PG_CRED.VLR_DESC + V_PG_CRED.VLR_DEVOLUCAO) AS DESC_DEV
						,(V_PG_CRED.VLR_JUROS + V_PG_CRED.VLR_DESP_OUTR) / CASE 
							WHEN (
									(
										SELECT COUNT(CC.CD_RAT_DESP)
										FROM PG_DESP_RAT_PG_CRED
										LEFT JOIN PG_DESP_RAT_CTB_CENTRO_CUSTO CC ON CC.CD_RAT_DESP = PG_DESP_RAT_PG_CRED.CD_RAT_DESP
										WHERE 1 = 1
											AND PG_DESP_RAT_PG_CRED.NR_DP = V_PG_CRED.NR_DP
											AND PG_DESP_RAT_PG_CRED.CD_EMP = V_PG_CRED.CD_EMP
											AND PG_DESP_RAT_PG_CRED.ANO = V_PG_CRED.ANO
											AND PG_DESP_RAT_PG_CRED.CD_FILIAL = V_PG_CRED.CD_FILIAL
										)
									) > 0
								THEN (
										(
											SELECT COUNT(CC.CD_RAT_DESP)
											FROM PG_DESP_RAT_PG_CRED
											LEFT JOIN PG_DESP_RAT_CTB_CENTRO_CUSTO CC ON CC.CD_RAT_DESP = PG_DESP_RAT_PG_CRED.CD_RAT_DESP
											WHERE 1 = 1
												AND PG_DESP_RAT_PG_CRED.NR_DP = V_PG_CRED.NR_DP
												AND PG_DESP_RAT_PG_CRED.CD_EMP = V_PG_CRED.CD_EMP
												AND PG_DESP_RAT_PG_CRED.ANO = V_PG_CRED.ANO
												AND PG_DESP_RAT_PG_CRED.CD_FILIAL = V_PG_CRED.CD_FILIAL
											)
										)
							ELSE 1
							END AS TAXA_JUROS  
					,((( CASE WHEN SUM(VLR_DOC) > 0 THEN 
								( CASE WHEN @TP_DT IN ( 0, 1, 2, 3 ) THEN 
									CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA ) ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
												1 
											ELSE 
												VLR_DOC
											END))))											
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA) ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
													1
												ELSE 
													VLR_DOC
												END )
											
											))))
									ELSE
										SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - 
										( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / (( V_PG_CRED.VLR_DP  ) ) ) * V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP  ) 
										/ ( CASE WHEN VLR_DOC = 0 THEN 
												1
											ELSE 
												VLR_DOC
										END)), (PG_DESP_RAT.VLR_DESP - (V_PG_CRED.VLR_DESC_DEB - V_PG_CRED.VLR_DESP_OUTR + V_PG_CRED.VLR_IMP_DEB + V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) 
										/ ( CASE WHEN VLR_DOC = 0 THEN 
												1
											ELSE 
												VLR_DOC
											END))))
									END
									ELSE 
										CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA) ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
												1 
											ELSE 
												VLR_DOC
											END))))
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA ) )
											/ ( CASE WHEN VLR_DOC = 0 THEN 
													1
												ELSE 
													VLR_DOC
												END )
											
											))))
										 ELSE
											SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - ( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / ( CONVERT(NUMERIC(32, 8), ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS )) ) ) * 
											( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) ) * ( ( V_PG_CRED.VLR_DP   ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
												1 
											ELSE 
												VLR_DOC
											END ) ), (PG_DESP_RAT.VLR_DESP - ( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) * ( ( V_PG_CRED.VLR_DP  ) 
											/ ( CASE WHEN VLR_DOC = 0 THEN 
													1
												ELSE 
													VLR_DOC
												END ) )))
										END
									END )
							 ELSE 
								0		
						END )) - ISNULL(T0.VLR_IMP_DEB,0)) AS VLR_LIQ
						
						,PG_TP_FORN.DS_TP
						,'CONTAS A PAGAR'                               AS TRANSACAO
						,GLB_DESP_REC.DS_DESP_REC
						,V_PG_CRED.HIST                                 HIST_PG_CRED
						,ISNULL(CTB_CENTRO_CUSTO.DS_CENTRO_CTB, 0)      DS_CENTRO_CTB
						,V_PG_CRED.DT_VENCTO
						,PG_FORN.NM_FANT
						,V_PG_CRED.DUP_IMPOSTO
						,V_PG_CRED.CD_FILIAL AS CD_FILIAL_CRED
					FROM
						V_PG_CRED
						INNER JOIN PG_DESP_RAT_PG_CRED ON
							V_PG_CRED.CD_EMP = PG_DESP_RAT_PG_CRED.CD_EMP AND
							V_PG_CRED.CD_FILIAL = PG_DESP_RAT_PG_CRED.CD_FILIAL AND
							V_PG_CRED.NR_DP = PG_DESP_RAT_PG_CRED.NR_DP AND
							V_PG_CRED.ANO = PG_DESP_RAT_PG_CRED.ANO
						INNER JOIN V_PG_CRED_NF_QTDE_DOC_RELACIONADO_VALOR ON
							V_PG_CRED.CD_EMP = V_PG_CRED_NF_QTDE_DOC_RELACIONADO_VALOR.CD_EMP AND
							V_PG_CRED.CD_FILIAL = V_PG_CRED_NF_QTDE_DOC_RELACIONADO_VALOR.CD_FILIAL AND
							V_PG_CRED.NR_DP = V_PG_CRED_NF_QTDE_DOC_RELACIONADO_VALOR.NR_DP AND
							V_PG_CRED.ANO = V_PG_CRED_NF_QTDE_DOC_RELACIONADO_VALOR.ANO
						INNER JOIN PG_DESP_RAT ON
							PG_DESP_RAT_PG_CRED.CD_EMP = PG_DESP_RAT.CD_EMP AND
							PG_DESP_RAT_PG_CRED.CD_RAT_DESP = PG_DESP_RAT.CD_RAT_DESP
						LEFT JOIN PG_DESP_RAT_CTB_CENTRO_CUSTO ON
							PG_DESP_RAT.CD_EMP = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP AND
							PG_DESP_RAT.CD_RAT_DESP = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_RAT_DESP
						LEFT JOIN CTB_CENTRO_CUSTO ON
							PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP = CTB_CENTRO_CUSTO.CD_EMP AND
							PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_CENTRO_CTB = CTB_CENTRO_CUSTO.CD_CENTRO_CTB
						LEFT JOIN CTB_CENTRO_CUSTO_PRC_FILIAL ON
							CTB_CENTRO_CUSTO.CD_EMP = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_EMP AND
							CTB_CENTRO_CUSTO.CD_CENTRO_CTB = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_CENTRO_CTB
						INNER JOIN GLB_DESP_REC ON
							PG_DESP_RAT.CD_EMP = GLB_DESP_REC.CD_EMP AND
							PG_DESP_RAT.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC
						INNER JOIN PG_FORN ON
							V_PG_CRED.CD_EMP = PG_FORN.CD_EMP AND
							V_PG_CRED.CD_FORN = PG_FORN.CD_FORN
						LEFT OUTER JOIN CTB_HIST ON
							V_PG_CRED.CD_EMP = CTB_HIST.CD_EMP AND
							V_PG_CRED.CD_HIST = CTB_HIST.CD_HIST
						INNER JOIN PG_TP_FORN ON
							PG_FORN.CD_EMP = PG_TP_FORN.CD_EMP AND
							PG_FORN.CD_TP_FORN = PG_TP_FORN.CD_TP_FORN
						LEFT JOIN @CALC_IMP T0 ON
							T0.NR_DP = V_PG_CRED.NR_DP AND
							T0.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC
						
					WHERE
						V_PG_CRED.CD_EMP = @CD_EMP AND
						( CASE WHEN @TP_DT = 0 THEN V_PG_CRED.DT_EMIS
							WHEN @TP_DT = 1 THEN V_PG_CRED.DT_CAD
							WHEN @TP_DT = 2 THEN V_PG_CRED.DT_VENCTO
							WHEN @TP_DT = 4 THEN V_PG_CRED.DT_PAG
							ELSE PG_DESP_RAT.MES_ANO_REF
							END ) BETWEEN @DT_INI AND @DT_FIM AND
						V_PG_CRED.STS_DP <> 3
						AND
						( CASE WHEN @TP = 0 THEN @NR_CNT
							ELSE GLB_DESP_REC.NR_CNT
							END )             = @NR_CNT AND
						( CASE WHEN @TP_RAT_CUSTO = 0 THEN 1
							ELSE GLB_DESP_REC.RATEIO_CENTRO_CUSTO
							END )             = 1
							AND V_PG_CRED.DUP_IMPOSTO=0
					GROUP  BY
						GLB_DESP_REC.CD_DESP_REC
						,GLB_DESP_REC.NR_CNT
						,CTB_CENTRO_CUSTO.CD_CENTRO_CTB_REDU
						,V_PG_CRED.NR_DP
						,V_PG_CRED.PARC
						,V_PG_CRED.DT_EMIS
						,( CASE WHEN @TP_REL = 0 THEN NULL
							 ELSE ( CASE WHEN @TP_DT = 0 THEN V_PG_CRED.DT_EMIS
											WHEN @TP_DT = 1 THEN V_PG_CRED.DT_CAD
											WHEN @TP_DT = 2 THEN V_PG_CRED.DT_VENCTO
											WHEN @TP_DT = 4 THEN V_PG_CRED.DT_PAG
											ELSE PG_DESP_RAT.MES_ANO_REF
											END )
							 END )
						,V_PG_CRED.CD_EMP
						,V_PG_CRED.CD_FILIAL
						,V_PG_CRED.CD_FORN
						,PG_FORN.CD_TP_FORN
						,PG_FORN.NM_FANT
						,CTB_HIST.DS_HIST
						,PG_TP_FORN.DS_TP
						,GLB_DESP_REC.DS_DESP_REC
						,V_PG_CRED.HIST
						,CTB_CENTRO_CUSTO.DS_CENTRO_CTB
						,V_PG_CRED.DT_VENCTO
						,CTB_CENTRO_CUSTO_PRC_FILIAL.CD_FILIAL
						,PG_FORN.NM_FANT
						,V_PG_CRED.DUP_IMPOSTO 
						,ISNULL(T0.VLR_IMP_DEB,0)
						,(V_PG_CRED.VLR_DESC + V_PG_CRED.VLR_DEVOLUCAO)
						,(V_PG_CRED.VLR_JUROS + V_PG_CRED.VLR_DESP_OUTR)
						,PG_DESP_RAT.CD_RAT_DESP
						,V_PG_CRED.ANO
						
					--Duplicatas de imposto
					INSERT INTO @RS_FLUXO
						SELECT
						GLB_DESP_REC.CD_DESP_REC
						,GLB_DESP_REC.NR_CNT
						,ISNULL(CTB_CENTRO_CUSTO.CD_CENTRO_CTB_REDU, 0) CD_CENTRO_CTB_REDU
						,V_PG_CRED.NR_DP
						,V_PG_CRED.PARC
						,V_PG_CRED.DT_EMIS
						,( CASE WHEN @TP_REL = 0 THEN NULL
							 ELSE ( CASE WHEN @TP_DT = 0 THEN V_PG_CRED.DT_EMIS
											WHEN @TP_DT = 1 THEN V_PG_CRED.DT_CAD
											WHEN @TP_DT = 2 THEN V_PG_CRED.DT_VENCTO
											WHEN @TP_DT = 4 THEN V_PG_CRED.DT_PAG
											ELSE PG_DESP_RAT.MES_ANO_REF
											END )
							 END )                                        AS DT_SEL_REL
						,MAX(DT_PAG)                                    DT_PGTO
						,V_PG_CRED.CD_EMP
						,ISNULL(CTB_CENTRO_CUSTO_PRC_FILIAL.CD_FILIAL,V_PG_CRED.CD_FILIAL) AS CD_FILIAL
						,V_PG_CRED.CD_FORN
						,PG_FORN.CD_TP_FORN
						,PG_FORN.NM_FANT
						,MIN(V_PG_CRED.NR_TIT) AS NR_TIT
						,CTB_HIST.DS_HIST
/*:::::::::::::::::::::::::: VLR_SLD ::::::::::::::::::::::::::::::::::::::::::::::*/
						,( CASE WHEN SUM(VLR_DOC) > 0 THEN
								 CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
									 SUM(DISTINCT ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * ( ((V_PG_CRED.VLR_BAIXA+V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB)) / VLR_DP ), 
						PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA+V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB))  / VLR_DP )))
						ELSE 
							SUM(DISTINCT ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * ( V_PG_CRED.VLR_DP / VLR_DP ), 
							PG_DESP_RAT.VLR_DESP * ( V_PG_CRED.VLR_DP / VLR_DP)))
								 END
							 ELSE 
								0
							 END ) AS VLR_DP
						,CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
								 SUM(DISTINCT ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * ( V_PG_CRED.VLR_SLD / VLR_DP ), PG_DESP_RAT.VLR_DESP * ( V_PG_CRED.VLR_SLD /  VLR_DP )))
								 ELSE SUM(DISTINCT ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * ( V_PG_CRED.VLR_SLD / VLR_DP), PG_DESP_RAT.VLR_DESP * ( V_PG_CRED.VLR_SLD /  VLR_DP )))
								 END AS VLR_SLD

/*:::::::::::::::::::::::::: VLR_DESP ::::::::::::::::::::::::::::::::::::::::::::::*/
						,( CASE WHEN SUM(VLR_DOC) > 0 THEN 
								( CASE WHEN @TP_DT IN ( 0, 1, 2, 3 ) THEN 
									CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA+V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB)) 
											/  VLR_DP)))											
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA+V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB)) 
											/ VLR_DP
											
											))))
									ELSE
										SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - 
										( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / (( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) ) ) * V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) 
										/ VLR_DP), (PG_DESP_RAT.VLR_DESP - (V_PG_CRED.VLR_DESC_DEB - V_PG_CRED.VLR_DESP_OUTR + V_PG_CRED.VLR_IMP_DEB + V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) 
										/ VLR_DP)))
									END
									ELSE 
										CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA+V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB)) 
											/ VLR_DP)))
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA +V_PG_CRED.VLR_JUROS)-(V_PG_CRED.VLR_DESC+V_PG_CRED.VLR_IMP_DEB))
											/ VLR_DP
											
											))))
										 ELSE
											SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - ( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / ( CONVERT(NUMERIC(32, 8), ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS )) ) ) * 
											( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) ) * ( ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) 
											/ VLR_DP ), (PG_DESP_RAT.VLR_DESP - ( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) * ( ( V_PG_CRED.VLR_DP + V_PG_CRED.VLR_JUROS ) 
											/ VLR_DP )))
										END
									END )
							 ELSE 
								0
							 END )                                        AS VLR_DESP

/*:::::::::::::::::::::::::: VLR_DESP_BRUTA ::::::::::::::::::::::::::::::::::::::::::::::*/
					    , ( CASE WHEN SUM(VLR_DOC) > 0 THEN 
								( CASE WHEN @TP_DT IN ( 0, 1, 2, 3 ) THEN 
									CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA ) ) 
											/  VLR_DP)))											
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA ) ) 
											/ VLR_DP
											
											))))
									ELSE
										SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - 
										( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / (( V_PG_CRED.VLR_DP  ) ) ) * V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP   ) 
										/ VLR_DP), (PG_DESP_RAT.VLR_DESP - (V_PG_CRED.VLR_DESC_DEB - V_PG_CRED.VLR_DESP_OUTR + V_PG_CRED.VLR_IMP_DEB + V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP   ) 
										/ VLR_DP)))
									END
									ELSE 
										CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA ) ) 
											/ VLR_DP)))
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA  ) )
											/ VLR_DP
											
											))))
										 ELSE
											SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - ( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / ( CONVERT(NUMERIC(32, 8), ( V_PG_CRED.VLR_DP   )) ) ) * 
											( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) ) * ( ( V_PG_CRED.VLR_DP   ) 
											/ VLR_DP ), (PG_DESP_RAT.VLR_DESP - ( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) * ( ( V_PG_CRED.VLR_DP  ) 
											/ VLR_DP )))
										END
									END )
							 ELSE 
								0
							 END )                             			AS VLR_DESP_BRUTA
							 
						,ISNULL(T0.VLR_IMP_DEB,0) AS VLR_IMP_DEB
						,(V_PG_CRED.VLR_DESC + V_PG_CRED.VLR_DEVOLUCAO) AS DESC_DEV
						,(V_PG_CRED.VLR_JUROS + V_PG_CRED.VLR_DESP_OUTR) / CASE 
							WHEN (
									(
										SELECT COUNT(CC.CD_RAT_DESP)
										FROM PG_DESP_RAT_PG_CRED
										LEFT JOIN PG_DESP_RAT_CTB_CENTRO_CUSTO CC ON CC.CD_RAT_DESP = PG_DESP_RAT_PG_CRED.CD_RAT_DESP
										WHERE 1 = 1
											AND PG_DESP_RAT_PG_CRED.NR_DP = V_PG_CRED.NR_DP
											AND PG_DESP_RAT_PG_CRED.CD_EMP = V_PG_CRED.CD_EMP
											AND PG_DESP_RAT_PG_CRED.ANO = V_PG_CRED.ANO
											AND PG_DESP_RAT_PG_CRED.CD_FILIAL = V_PG_CRED.CD_FILIAL
										)
									) > 0
								THEN (
										(
											SELECT COUNT(CC.CD_RAT_DESP)
											FROM PG_DESP_RAT_PG_CRED
											LEFT JOIN PG_DESP_RAT_CTB_CENTRO_CUSTO CC ON CC.CD_RAT_DESP = PG_DESP_RAT_PG_CRED.CD_RAT_DESP
											WHERE 1 = 1
												AND PG_DESP_RAT_PG_CRED.NR_DP = V_PG_CRED.NR_DP
												AND PG_DESP_RAT_PG_CRED.CD_EMP = V_PG_CRED.CD_EMP
												AND PG_DESP_RAT_PG_CRED.ANO = V_PG_CRED.ANO
												AND PG_DESP_RAT_PG_CRED.CD_FILIAL = V_PG_CRED.CD_FILIAL
											)
										)
							ELSE 1
							END AS TAXA_JUROS   
						,((CASE WHEN SUM(VLR_DOC) > 0 THEN 
								( CASE WHEN @TP_DT IN ( 0, 1, 2, 3 ) THEN 
									CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA ) ) 
											/  VLR_DP)))											
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA ) ) 
											/ VLR_DP
											
											))))
									ELSE
										SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - 
										( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / (( V_PG_CRED.VLR_DP  ) ) ) * V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP   ) 
										/ VLR_DP), (PG_DESP_RAT.VLR_DESP - (V_PG_CRED.VLR_DESC_DEB - V_PG_CRED.VLR_DESP_OUTR + V_PG_CRED.VLR_IMP_DEB + V_PG_CRED.VLR_SLD ) ) * ( ( V_PG_CRED.VLR_DP   ) 
										/ VLR_DP)))
									END
									ELSE 
										CASE WHEN SUM(V_PG_CRED.VLR_BAIXA) > 0 THEN --TEVE PAGAMENTO
											SUM(DISTINCT ISNULL(
											((PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP * (((V_PG_CRED.VLR_BAIXA ) ) 
											/ VLR_DP)))
											,											
											(PG_DESP_RAT.VLR_DESP * ( ((V_PG_CRED.VLR_BAIXA  ) )
											/ VLR_DP
											
											))))
										 ELSE
											SUM(DISTINCT ISNULL(( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP - ( ( PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP / ( CONVERT(NUMERIC(32, 8), ( V_PG_CRED.VLR_DP   )) ) ) * 
											( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) ) * ( ( V_PG_CRED.VLR_DP   ) 
											/ VLR_DP ), (PG_DESP_RAT.VLR_DESP - ( V_PG_CRED.VLR_DESC_DEB + V_PG_CRED.VLR_IMP_DEB ) ) * ( ( V_PG_CRED.VLR_DP  ) 
											/ VLR_DP )))
										END
									END )
							 ELSE 
								0
							 END) - ISNULL(T0.VLR_IMP_DEB,0)) AS VLR_LIQ 							 
							 
						,PG_TP_FORN.DS_TP
						,'CONTAS A PAGAR'                               AS TRANSACAO
						,GLB_DESP_REC.DS_DESP_REC
						,V_PG_CRED.HIST                                 HIST_PG_CRED
						,ISNULL(CTB_CENTRO_CUSTO.DS_CENTRO_CTB, 0)      DS_CENTRO_CTB
						,V_PG_CRED.DT_VENCTO
						,PG_FORN.NM_FANT
						,V_PG_CRED.DUP_IMPOSTO
						,V_PG_CRED.CD_FILIAL AS CD_FILIAL_CRED
					FROM
						V_PG_CRED
						INNER JOIN PG_DESP_RAT_PG_CRED ON
							V_PG_CRED.CD_EMP = PG_DESP_RAT_PG_CRED.CD_EMP AND
							V_PG_CRED.CD_FILIAL = PG_DESP_RAT_PG_CRED.CD_FILIAL AND
							V_PG_CRED.NR_DP = PG_DESP_RAT_PG_CRED.NR_DP AND
							V_PG_CRED.ANO = PG_DESP_RAT_PG_CRED.ANO
						INNER JOIN V_PG_CRED_NF_QTDE_DOC_RELACIONADO_VALOR ON
							V_PG_CRED.CD_EMP = V_PG_CRED_NF_QTDE_DOC_RELACIONADO_VALOR.CD_EMP AND
							V_PG_CRED.CD_FILIAL = V_PG_CRED_NF_QTDE_DOC_RELACIONADO_VALOR.CD_FILIAL AND
							V_PG_CRED.NR_DP = V_PG_CRED_NF_QTDE_DOC_RELACIONADO_VALOR.NR_DP AND
							V_PG_CRED.ANO = V_PG_CRED_NF_QTDE_DOC_RELACIONADO_VALOR.ANO
						INNER JOIN PG_DESP_RAT ON
							PG_DESP_RAT_PG_CRED.CD_EMP = PG_DESP_RAT.CD_EMP AND
							PG_DESP_RAT_PG_CRED.CD_RAT_DESP = PG_DESP_RAT.CD_RAT_DESP
						LEFT JOIN PG_DESP_RAT_CTB_CENTRO_CUSTO ON
							PG_DESP_RAT.CD_EMP = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP AND
							PG_DESP_RAT.CD_RAT_DESP = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_RAT_DESP
						LEFT JOIN CTB_CENTRO_CUSTO ON
							PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP = CTB_CENTRO_CUSTO.CD_EMP AND
							PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_CENTRO_CTB = CTB_CENTRO_CUSTO.CD_CENTRO_CTB
						LEFT JOIN CTB_CENTRO_CUSTO_PRC_FILIAL ON
							CTB_CENTRO_CUSTO.CD_EMP = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_EMP AND
							CTB_CENTRO_CUSTO.CD_CENTRO_CTB = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_CENTRO_CTB
						INNER JOIN GLB_DESP_REC ON
							PG_DESP_RAT.CD_EMP = GLB_DESP_REC.CD_EMP AND
							PG_DESP_RAT.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC
						INNER JOIN PG_FORN ON
							V_PG_CRED.CD_EMP = PG_FORN.CD_EMP AND
							V_PG_CRED.CD_FORN = PG_FORN.CD_FORN
						LEFT OUTER JOIN CTB_HIST ON
							V_PG_CRED.CD_EMP = CTB_HIST.CD_EMP AND
							V_PG_CRED.CD_HIST = CTB_HIST.CD_HIST
						INNER JOIN PG_TP_FORN ON
							PG_FORN.CD_EMP = PG_TP_FORN.CD_EMP AND
							PG_FORN.CD_TP_FORN = PG_TP_FORN.CD_TP_FORN
						LEFT JOIN @CALC_IMP T0 ON
							T0.NR_DP = V_PG_CRED.NR_DP AND
							T0.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC							
							
					WHERE
						V_PG_CRED.CD_EMP = @CD_EMP AND
						( CASE WHEN @TP_DT = 0 THEN V_PG_CRED.DT_EMIS
							WHEN @TP_DT = 1 THEN V_PG_CRED.DT_CAD
							WHEN @TP_DT = 2 THEN V_PG_CRED.DT_VENCTO
							WHEN @TP_DT = 4 THEN V_PG_CRED.DT_PAG
							ELSE PG_DESP_RAT.MES_ANO_REF
							END ) BETWEEN @DT_INI AND @DT_FIM AND
						V_PG_CRED.STS_DP <> 3
						AND
						( CASE WHEN @TP = 0 THEN @NR_CNT
							ELSE GLB_DESP_REC.NR_CNT
							END )             = @NR_CNT AND
						( CASE WHEN @TP_RAT_CUSTO = 0 THEN 1
							ELSE GLB_DESP_REC.RATEIO_CENTRO_CUSTO
							END )             = 1
						AND V_PG_CRED.DUP_IMPOSTO=1
					GROUP  BY
						GLB_DESP_REC.CD_DESP_REC
						,GLB_DESP_REC.NR_CNT
						,CTB_CENTRO_CUSTO.CD_CENTRO_CTB_REDU
						,V_PG_CRED.NR_DP
						,V_PG_CRED.PARC
						,V_PG_CRED.DT_EMIS
						,( CASE WHEN @TP_REL = 0 THEN NULL
							 ELSE ( CASE WHEN @TP_DT = 0 THEN V_PG_CRED.DT_EMIS
											WHEN @TP_DT = 1 THEN V_PG_CRED.DT_CAD
											WHEN @TP_DT = 2 THEN V_PG_CRED.DT_VENCTO
											WHEN @TP_DT = 4 THEN V_PG_CRED.DT_PAG
											ELSE PG_DESP_RAT.MES_ANO_REF
											END )
							 END )
						,V_PG_CRED.CD_EMP
						,V_PG_CRED.CD_FILIAL
						,V_PG_CRED.CD_FORN
						,PG_FORN.CD_TP_FORN
						,PG_FORN.NM_FANT
						,CTB_HIST.DS_HIST
						,PG_TP_FORN.DS_TP
						,GLB_DESP_REC.DS_DESP_REC
						,V_PG_CRED.HIST
						,CTB_CENTRO_CUSTO.DS_CENTRO_CTB
						,V_PG_CRED.DT_VENCTO
						,CTB_CENTRO_CUSTO_PRC_FILIAL.CD_FILIAL
						,PG_FORN.NM_FANT
						,V_PG_CRED.DUP_IMPOSTO 
						,ISNULL(T0.VLR_IMP_DEB,0)
						,(V_PG_CRED.VLR_DESC + V_PG_CRED.VLR_DEVOLUCAO)
						,(V_PG_CRED.VLR_JUROS + V_PG_CRED.VLR_DESP_OUTR)
						,PG_DESP_RAT.CD_RAT_DESP
						,V_PG_CRED.ANO
						
					INSERT INTO @RS_FLUXO
					SELECT
						GLB_DESP_REC.CD_DESP_REC
						,GLB_DESP_REC.NR_CNT
						,CTB_CENTRO_CUSTO.CD_CENTRO_CTB_REDU
						,BC_LANC.CD_BC_LANC                                                      AS NR_DP
						,0                                                                       AS PARC
						,BC_LANC.DT_LANCTO                                                       AS DT_EMI_NF
						,( CASE WHEN @TP_DT = 3 THEN PG_DESP_RAT.MES_ANO_REF
							 ELSE BC_LANC.DT_LANCTO
							 END )                                                               AS DT_SEL_REL
						,BC_LANC.DT_LANCTO                                                       AS DT_PGTO
						,PG_DESP_RAT.CD_EMP
						,ISNULL(CTB_CENTRO_CUSTO_PRC_FILIAL.CD_FILIAL,PG_DESP_RAT.CD_FILIAL)     AS CD_FILIAL
						,0                                                                       AS CD_FORN
						,ISNULL(PG_TP_FORN.CD_TP_FORN, 0)                                        AS CD_TP_FORN
						,GLB_DESP_REC.DS_DESP_REC                                                AS NM_FANT
						,CONVERT(VARCHAR(50), BC_LANC.CD_BC_LANC)                                AS NR_TIT
						,BC_LANC.HIST_LANC                                                       AS HIST
						,ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP, PG_DESP_RAT.VLR_DESP) AS VLR_DP
						,0                                                                       AS VLR_SLD
						,ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP, PG_DESP_RAT.VLR_DESP) AS VLR_DESP
						,0																	     AS VLR_DESP_BRUTA
						,0																		 AS VLR_IMP_DEB
						,0																		 AS DESC_DEV
						,0																		 AS TAXA_JUROS  
						,ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP, PG_DESP_RAT.VLR_DESP) AS VLR_LIQ						
						,PG_TP_FORN.DS_TP
						,'BANCARIO'                                                              AS TRANSACAO
						,GLB_DESP_REC.DS_DESP_REC
						,BC_LANC.HIST_LANC                                                       AS HIST_PG_CRED
						,ISNULL(CTB_CENTRO_CUSTO.DS_CENTRO_CTB, 0)                               AS DS_CENTRO_CTB
						,BC_LANC.DT_LANCTO
						,'BANCARIO' 															 AS NM_FANT
						,0 AS DUP_IMPOSTO
						,PG_DESP_RAT.CD_FILIAL AS CD_FILIAL_CRED
					FROM
						BC_LANC
						INNER JOIN PG_DESP_RAT_BC_LANC ON
							BC_LANC.CD_EMP = PG_DESP_RAT_BC_LANC.CD_EMP AND
							BC_LANC.CD_BC_LANC = PG_DESP_RAT_BC_LANC.CD_BC_LANC
						INNER JOIN PG_DESP_RAT ON
							PG_DESP_RAT_BC_LANC.CD_EMP = PG_DESP_RAT.CD_EMP AND
							PG_DESP_RAT_BC_LANC.CD_RAT_DESP = PG_DESP_RAT.CD_RAT_DESP
						LEFT JOIN PG_DESP_RAT_CTB_CENTRO_CUSTO ON
							PG_DESP_RAT.CD_EMP = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP AND
							PG_DESP_RAT.CD_RAT_DESP = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_RAT_DESP
						LEFT JOIN CTB_CENTRO_CUSTO ON
							PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP = CTB_CENTRO_CUSTO.CD_EMP AND
							PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_CENTRO_CTB = CTB_CENTRO_CUSTO.CD_CENTRO_CTB
						LEFT JOIN CTB_CENTRO_CUSTO_PRC_FILIAL ON
							CTB_CENTRO_CUSTO.CD_EMP = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_EMP AND
							CTB_CENTRO_CUSTO.CD_CENTRO_CTB = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_CENTRO_CTB

						INNER JOIN GLB_DESP_REC ON
							PG_DESP_RAT.CD_EMP = GLB_DESP_REC.CD_EMP AND
							PG_DESP_RAT.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC
						INNER JOIN RC_TP_LANC ON
							BC_LANC.CD_EMP = RC_TP_LANC.CD_EMP AND
							BC_LANC.CD_TP_LANC = RC_TP_LANC.CD_TP_LANC
						INNER JOIN PG_TP_FORN ON
							RC_TP_LANC.CD_EMP = PG_TP_FORN.CD_EMP AND
							RC_TP_LANC.CD_CLASS_FLUXO_CX = PG_TP_FORN.CD_TP_FORN
					WHERE
						BC_LANC.CD_EMP = @CD_EMP AND
						( CASE WHEN @TP_DT = 3 THEN PG_DESP_RAT.MES_ANO_REF
							ELSE BC_LANC.DT_LANCTO
							END ) BETWEEN @DT_INI AND @DT_FIM AND
						( CASE WHEN @TP = 0 THEN @NR_CNT
							ELSE GLB_DESP_REC.NR_CNT
							END )           = @NR_CNT AND
						( CASE WHEN @TP_RAT_CUSTO = 0 THEN 1
							ELSE GLB_DESP_REC.RATEIO_CENTRO_CUSTO
							END )  
							         = 1
							
							
					INSERT INTO @RS_FLUXO
					SELECT
						GLB_DESP_REC.CD_DESP_REC
						,GLB_DESP_REC.NR_CNT
						,CTB_CENTRO_CUSTO.CD_CENTRO_CTB_REDU
						,0                                                                       AS NR_DP
						,0                                                                       AS PARC
						,RC_CLI_CONV_GLOSA_PG_DESP_RAT.DT_LANC                                   AS DT_EMI_NF
						,( CASE WHEN @TP_DT = 3 THEN PG_DESP_RAT.MES_ANO_REF
							 ELSE RC_CLI_CONV_GLOSA_PG_DESP_RAT.DT_LANC
							 END )                                                               AS DT_SEL_REL
						,RC_CLI_CONV_GLOSA_PG_DESP_RAT.DT_LANC                                   AS DT_PGTO
						,PG_DESP_RAT.CD_EMP
						,ISNULL(CTB_CENTRO_CUSTO_PRC_FILIAL.CD_FILIAL,PG_DESP_RAT.CD_FILIAL)     AS CD_FILIAL
						,0                                                                       AS CD_FORN
						,0                                                                       AS CD_TP_FORN
						,GLB_DESP_REC.DS_DESP_REC                                                AS NM_FANT
						,''                                                                      AS NR_TIT
						,'GLOSA DE CONVENIO'                                                     AS HIST
						,PG_DESP_RAT.VLR_DESP                                                    AS VLR_DP
						,0                                                                       AS SLD_DP
						,ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP, PG_DESP_RAT.VLR_DESP) AS VLR_DESP
						,0																	     AS VLR_DESP_BRUTA
						,0																		 AS VLR_IMP_DEB
						,0																		 AS DESC_DEV
						,0																		 AS TAXA_JUROS  
						,PG_DESP_RAT.VLR_DESP													 AS VLR_LIQ						
						,'GLOSA DE CONVENIO'                                                     AS DS_TP
						,'CONVENIO'                                                              AS TRANSACAO
						,GLB_DESP_REC.DS_DESP_REC
						,'GLOSA DE CONVENIO'                                                     HIST_PG_CRED
						,ISNULL(CTB_CENTRO_CUSTO.DS_CENTRO_CTB, 0)                               DS_CENTRO_CTB
						,RC_CLI_CONV_GLOSA_PG_DESP_RAT.DT_LANC
						,RC_CLI_CONV.DS_CONV AS NM_FANT
						, 0 AS DUP_IMPOSTO
						,PG_DESP_RAT.CD_FILIAL AS CD_FILIAL_CRED
					FROM
						RC_CLI_CONV_GLOSA_PG_DESP_RAT
						INNER JOIN PG_DESP_RAT ON
							RC_CLI_CONV_GLOSA_PG_DESP_RAT.CD_EMP = PG_DESP_RAT.CD_EMP AND
							RC_CLI_CONV_GLOSA_PG_DESP_RAT.CD_RAT_DESP = PG_DESP_RAT.CD_RAT_DESP
						LEFT JOIN PG_DESP_RAT_CTB_CENTRO_CUSTO ON
							PG_DESP_RAT.CD_EMP = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP AND
							PG_DESP_RAT.CD_RAT_DESP = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_RAT_DESP
						LEFT JOIN CTB_CENTRO_CUSTO ON
							PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP = CTB_CENTRO_CUSTO.CD_EMP AND
							PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_CENTRO_CTB = CTB_CENTRO_CUSTO.CD_CENTRO_CTB
						LEFT JOIN CTB_CENTRO_CUSTO_PRC_FILIAL ON
							CTB_CENTRO_CUSTO.CD_EMP = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_EMP AND
							CTB_CENTRO_CUSTO.CD_CENTRO_CTB = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_CENTRO_CTB

						INNER JOIN GLB_DESP_REC ON
							PG_DESP_RAT.CD_EMP = GLB_DESP_REC.CD_EMP AND
							PG_DESP_RAT.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC
						INNER JOIN RC_CLI_CONV ON
						RC_CLI_CONV_GLOSA_PG_DESP_RAT.CD_EMP = RC_CLI_CONV.CD_EMP AND 
						RC_CLI_CONV_GLOSA_PG_DESP_RAT.CD_CONV = RC_CLI_CONV.CD_CONV	
					WHERE
						( CASE WHEN @TP = 0 THEN @NR_CNT
							ELSE GLB_DESP_REC.NR_CNT
							END ) = @NR_CNT AND
						( CASE WHEN @TP_DT = 3 THEN PG_DESP_RAT.MES_ANO_REF
							ELSE RC_CLI_CONV_GLOSA_PG_DESP_RAT.DT_LANC
							END ) BETWEEN @DT_INI AND @DT_FIM AND
						( CASE WHEN @TP_RAT_CUSTO = 0 THEN 1
							ELSE GLB_DESP_REC.RATEIO_CENTRO_CUSTO
							END ) = 1


					INSERT INTO @RS_FLUXO
						SELECT
						GLB_DESP_REC.CD_DESP_REC
						,GLB_DESP_REC.NR_CNT
						,CTB_CENTRO_CUSTO.CD_CENTRO_CTB_REDU
						,0                                                                       AS NR_DP
						,0                                                                       AS PARC
						,PG_DESP_RAT_PDV_VD_FECHA_MOV.DT_MOV                                     AS DT_EMI_NF
						,( CASE WHEN @TP_DT = 3 THEN PG_DESP_RAT.MES_ANO_REF
							 ELSE PG_DESP_RAT_PDV_VD_FECHA_MOV.DT_MOV
							 END )                                                               AS DT_SEL_REL
						,PG_DESP_RAT_PDV_VD_FECHA_MOV.DT_MOV                                     AS DT_PGTO
						,PG_DESP_RAT.CD_EMP
						,ISNULL(CTB_CENTRO_CUSTO_PRC_FILIAL.CD_FILIAL,PG_DESP_RAT.CD_FILIAL) AS CD_FILIAL
						,0                                                                       AS CD_FORN
						,0                                                                       AS CD_TP_FORN
						,GLB_DESP_REC.DS_DESP_REC                                                AS NM_FANT
						,''                                                                      AS NR_TIT
						,GLB_DESP_REC.DS_DESP_REC                                                AS HIST
						,ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP, PG_DESP_RAT.VLR_DESP) AS VLR_DP
						,0                                                                       AS SLD_DP
						,ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP, PG_DESP_RAT.VLR_DESP) AS VLR_DESP
						,0																		 AS	VLR_DESP_BRUTA
						,0																		 AS VLR_IMP_DEB
						,0																		 AS DESC_DEV
						,0																		 AS TAXA_JUROS  
						,ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP, PG_DESP_RAT.VLR_DESP) AS VLR_LIQ						
						,'DESPESAS LANCADAS NO FECHAMENTO DE CAIXA'                              AS DS_TP
						,'FECHAMENTO DE CAIXA'                                                   AS TRANSACAO
						,GLB_DESP_REC.DS_DESP_REC
						,GLB_DESP_REC.DS_DESP_REC                                                HIST_PG_CRED
						,ISNULL(CTB_CENTRO_CUSTO.DS_CENTRO_CTB, 0)                               DS_CENTRO_CTB
						,PG_DESP_RAT_PDV_VD_FECHA_MOV.DT_MOV                                     AS DT_EMI_NF
						,'FECHAMENTO CAIXA' AS NM_FANT
						,0 AS DUP_IMPOSTO
						,PG_DESP_RAT.CD_FILIAL AS CD_FILIAL_CRED
					FROM
						PG_DESP_RAT_PDV_VD_FECHA_MOV
						INNER JOIN PG_DESP_RAT ON
							PG_DESP_RAT_PDV_VD_FECHA_MOV.CD_EMP = PG_DESP_RAT.CD_EMP AND
							PG_DESP_RAT_PDV_VD_FECHA_MOV.CD_RAT_DESP = PG_DESP_RAT.CD_RAT_DESP
						INNER JOIN GLB_DESP_REC ON
							PG_DESP_RAT.CD_EMP = GLB_DESP_REC.CD_EMP AND
							PG_DESP_RAT.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC
						LEFT JOIN PG_DESP_RAT_CTB_CENTRO_CUSTO ON
							PG_DESP_RAT.CD_EMP = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP AND
							PG_DESP_RAT.CD_RAT_DESP = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_RAT_DESP
						LEFT JOIN CTB_CENTRO_CUSTO ON
							PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP = CTB_CENTRO_CUSTO.CD_EMP AND
							PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_CENTRO_CTB = CTB_CENTRO_CUSTO.CD_CENTRO_CTB
						LEFT JOIN CTB_CENTRO_CUSTO_PRC_FILIAL ON
							CTB_CENTRO_CUSTO.CD_EMP = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_EMP AND
							CTB_CENTRO_CUSTO.CD_CENTRO_CTB = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_CENTRO_CTB
					WHERE
						( CASE WHEN @TP = 0 THEN @NR_CNT
							ELSE GLB_DESP_REC.NR_CNT
							END ) = @NR_CNT AND
						( CASE WHEN @TP_DT = 3 THEN PG_DESP_RAT.MES_ANO_REF
							ELSE PG_DESP_RAT_PDV_VD_FECHA_MOV.DT_MOV
							END ) BETWEEN @DT_INI AND @DT_FIM AND
						( CASE WHEN @TP_RAT_CUSTO = 0 THEN 1
							ELSE GLB_DESP_REC.RATEIO_CENTRO_CUSTO
							END ) = 1

					INSERT INTO @RS_FLUXO
					SELECT
						GLB_DESP_REC.CD_DESP_REC
						,GLB_DESP_REC.NR_CNT
						,CTB_CENTRO_CUSTO.CD_CENTRO_CTB_REDU
						,RC_ADM_CARTAO_MOV.CD_CTR                                                AS NR_DP
						,0                                                                       AS PARC
						,RC_ADM_CARTAO_MOV.DT_LANC                                               AS DT_EMI_NF
						,( CASE WHEN @TP_DT = 3 THEN PG_DESP_RAT.MES_ANO_REF
							 ELSE RC_ADM_CARTAO_MOV.DT_LANC
							 END )                                                               AS DT_SEL_REL
						,RC_ADM_CARTAO_MOV.DT_LANC                                               AS DT_PGTO
						,RC_ADM_CARTAO_MOV.CD_EMP
						,ISNULL(CTB_CENTRO_CUSTO_PRC_FILIAL.CD_FILIAL,PG_DESP_RAT.CD_FILIAL) 	 AS CD_FILIAL
						,0                                                                       AS CD_FORN
						,0                                                                       AS TP_FORN
						,GLB_DESP_REC.DS_DESP_REC                                                AS NM_FANT
						,''                                                                      AS NR_TIT
						,GLB_DESP_REC.DS_DESP_REC                                                AS HIST
						,ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP, PG_DESP_RAT.VLR_DESP) AS VLR_DP
						,0                                                                       AS SLD_DP
						,ISNULL(PG_DESP_RAT_CTB_CENTRO_CUSTO.VLR_RAT_DESP, PG_DESP_RAT.VLR_DESP) AS VLR_DESP
						,0																		 AS	VLR_DESP_BRUTA
						,0																		 AS VLR_IMP_DEB
						,0																		 AS DESC_DEV
						,0																		 AS TAXA_JUROS  
						,0																		 AS VLR_LIQ						
						,'CONTROLE DE CARTOES'                                                   AS DS_TP
						,'CONTROLE DE CARTOES'                                                   AS TRANSACAO
						,GLB_DESP_REC.DS_DESP_REC
						,GLB_DESP_REC.DS_DESP_REC                                                HIST_PG_CRED
						,ISNULL(CTB_CENTRO_CUSTO.DS_CENTRO_CTB, 0)                               DS_CENTRO_CTB
						,RC_ADM_CARTAO_MOV.DT_VENCTO
						,RC_CLI.NM_FANT
						,0 AS DUP_IMPOSTO
						,PG_DESP_RAT.CD_FILIAL AS CD_FILIAL_CRED
					FROM
						RC_ADM_CARTAO_MOV INNER JOIN PG_DESP_RAT_RC_ADM_CARTAO_MOV ON
						RC_ADM_CARTAO_MOV.CD_CTR = PG_DESP_RAT_RC_ADM_CARTAO_MOV.CD_CTR
						INNER JOIN PG_DESP_RAT ON
						PG_DESP_RAT_RC_ADM_CARTAO_MOV.CD_EMP = PG_DESP_RAT.CD_EMP AND
						PG_DESP_RAT_RC_ADM_CARTAO_MOV.CD_RAT_DESP = PG_DESP_RAT.CD_RAT_DESP
						INNER JOIN GLB_DESP_REC ON
						PG_DESP_RAT.CD_EMP = GLB_DESP_REC.CD_EMP AND
						PG_DESP_RAT.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC 
						LEFT OUTER JOIN PG_DESP_RAT_CTB_CENTRO_CUSTO ON
						PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP = PG_DESP_RAT.CD_EMP AND
						PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_RAT_DESP = PG_DESP_RAT.CD_RAT_DESP						
						LEFT OUTER JOIN CTB_CENTRO_CUSTO ON
						CTB_CENTRO_CUSTO.CD_EMP = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_EMP AND
						CTB_CENTRO_CUSTO.CD_CENTRO_CTB = PG_DESP_RAT_CTB_CENTRO_CUSTO.CD_CENTRO_CTB
						LEFT JOIN CTB_CENTRO_CUSTO_PRC_FILIAL ON
							CTB_CENTRO_CUSTO.CD_EMP = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_EMP AND
							CTB_CENTRO_CUSTO.CD_CENTRO_CTB = CTB_CENTRO_CUSTO_PRC_FILIAL.CD_CENTRO_CTB
						INNER JOIN RC_CLI ON
						RC_ADM_CARTAO_MOV.CD_EMP = RC_CLI.CD_EMP AND
						RC_ADM_CARTAO_MOV.CD_CLI = RC_CLI.CD_CLI 
					WHERE
						( CASE WHEN @TP = 0 THEN @NR_CNT
							ELSE GLB_DESP_REC.NR_CNT
							END ) = @NR_CNT AND
						( CASE WHEN @TP_DT = 3 THEN PG_DESP_RAT.MES_ANO_REF
							ELSE RC_ADM_CARTAO_MOV.DT_LANC
							END ) BETWEEN @DT_INI AND @DT_FIM AND
						( CASE WHEN @TP_RAT_CUSTO = 0 THEN 1
							ELSE GLB_DESP_REC.RATEIO_CENTRO_CUSTO
							END ) = 1

				  INSERT INTO @RS_FLUXO
				  	SELECT
						0																	  AS CD_DESP_REC
						,ISNULL(desp.NR_CNT,'')											      AS NR_CNT
						,ISNULL(desp.CD_CENTRO_CTB_REDU,0)									  AS CD_CENTRO_CTB_REDU
						,RC_CRED.CD_RC_DEB                                                    AS NR_DP
						,0                                                                    AS PARC
						,RC_CRED.DT_PAG														  AS DT_EMI_NF
						,RC_CRED.DT_PAG														  AS DT_SEL_REL
						,RC_CRED.DT_PAG			                                              AS DT_PGTO
						,RC_CRED.CD_EMP
						,ISNULL(DESP.CD_FILIAL,RC_CRED.CD_FILIAL)							  AS CD_FILIAL
						,0                                                                    AS CD_FORN
						,0                                                                    AS TP_FORN
						,ISNULL(DESP.DS_DESP_REC,'21-DESC.CONCEDIDOS-NAO CONF')				  AS NM_FANT
						,''                                                                   AS NR_TIT
						,ISNULL(DESP.DS_DESP_REC,'21-DESC.CONCEDIDOS-NAO CONF')				  AS HIST
						,RC_CRED.VL_DESC													  AS VLR_DP
						,0                                                                    AS SLD_DP
						,RC_CRED.VL_DESC													  AS VLR_DESP
						,0																	  AS VLR_DESP_BRUTA
						,0																	  AS VLR_IMP_DEB
						,0																	  AS DESC_DEV
						,0																	  AS TAXA_JUROS  
						,RC_CRED.VL_DESC													  AS VLR_LIQ						
						,'CONTAS A RECEBER'                                                   AS DS_TP
						,'CONTAS A RECEBER'                                                   AS TRANSACAO
						,ISNULL(DESP.DS_DESP_REC,'DESCONTOS CONCEDIDOS')
						,ISNULL(DESP.DS_DESP_REC,'21-DESC.CONCEDIDOS-NAO CONF')	              AS HIST_PG_CRED
						,ISNULL(CTB_CENTRO_CUSTO.DS_CENTRO_CTB, '')                           AS DS_CENTRO_CTB
						,RC_CRED.DT_PAG
						,RC_CLI.NM_FANT
						, 0																	  AS DUP_IMPOSTO
						,RC_CRED.CD_FILIAL AS CD_FILIAL_CRED
					FROM
						RC_CRED INNER JOIN RC_DEB ON
						RC_CRED.CD_EMP = RC_DEB.CD_EMP AND
						RC_CRED.CD_FILIAL = RC_DEB.CD_FILIAL AND
						RC_CRED.CD_RC_DEB= RC_DEB.CD_RC_DEB
						INNER JOIN RC_CLI ON
						RC_DEB.CD_EMP = RC_CLI.CD_EMP AND
						RC_DEB.CD_CLI = RC_CLI.CD_CLI 
						LEFT OUTER JOIN (SELECT
										CD_EMP,
										CD_FILIAL,
										CD_CTB_CNT AS NR_CNT,
										CD_CTB_CNT_RED AS CD_CENTRO_CTB_REDU,
										CD_CENTRO_CTB,
										'DESCONTOS CONCEDIDOS' AS DS_DESP_REC
									FROM
										PRC_FILIAL_CNT_CTB
									WHERE
										TP_CNT_CTB=21) desp ON
						RC_CRED.CD_EMP = desp.CD_EMP AND
						RC_CRED.CD_FILIAL = desp.CD_FILIAL 
						LEFT OUTER JOIN CTB_CENTRO_CUSTO ON
						desp.CD_EMP = CTB_CENTRO_CUSTO.CD_EMP AND
						desp.CD_CENTRO_CTB = CTB_CENTRO_CUSTO.CD_CENTRO_CTB
					WHERE
						RC_CRED.DT_PAG BETWEEN @DT_INI AND @DT_FIM
						AND RC_CRED.VL_DESC>0
						AND ( CASE WHEN @TP_RAT_CUSTO = 0 THEN 1
								ELSE DESP.CD_CENTRO_CTB
							END ) = 1 
						AND ( CASE WHEN @TP = 0 THEN @NR_CNT
							ELSE DESP.NR_CNT
							END ) = @NR_CNT
			END

			------------------------------------------------------------------------------
			INSERT INTO @RETORNO_FLUXO
			SELECT
				CD_DESP_REC
				,CD_CHAVE
				,ISNULL(CD_CENTRO_CTB_REDU, 0)
				,NR_DP
				,PARC
				,DT_EMI
				,DT_SEL_REL
				,DT_PGTO
				,CD_EMP
				,CD_FILIAL
				,CD_FORN
				,CD_TP_FORN
				,FORN
				,DOC
				,HIST
				,VLR_DP
				,VLR_SLD
				,VLR_DESP
				,VLR_DESP_BRUTA
				,VLR_IMP_DEB
				,DESC_DEV
				,TAXA_JUROS  
				,VLR_LIQ				
				,DS_TP
				,TRANSACAO
				,DS_DESP_REC
				,HIST_PG_CRED
				,DS_CENTRO_CTB
				,DT_VENCTO
				,NM_FORN
				,CASE WHEN DUP_IMPOSTO=0 THEN 'NAO' ELSE 'SIM' END  AS DUP_IMPOSTO
				,CD_FILIAL_CRED
			FROM
				@RS_FLUXO

			RETURN
	END 
GO


